using System;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary
{
	/// <summary>
	/// This class represents exceptions that may during string parsing in simple
	/// classes during serialization/deserialization. 
	/// </summary>
	public class StringParseException : FlatMediumParseException
	{
		/// <summary>
		/// Default parameterless constructor. Should be avoided whenever possible.
		/// </summary>
		public StringParseException() 
			: base() {}

		/// <summary>
		/// This constructor allows specifying an error message upon throwing an exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		public StringParseException( string message )
			: base( message ) {}

		/// <summary>
		/// This constructor allows adding inner exception that caused this exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		/// <param name="inner">Inner exception that caused this exception.</param>
		public StringParseException( string message, Exception inner )
			: base( message, inner ) {}
	}
}
